/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.MaskFormatter;

public class TextInputDemo
extends JPanel
implements ActionListener,
FocusListener {
    JTextField streetField;
    JTextField cityField;
    JFormattedTextField zipField;
    JSpinner stateSpinner;
    boolean addressSet = false;
    Font regularFont;
    Font italicFont;
    JLabel addressDisplay;
    static final int GAP = 10;

    public TextInputDemo() {
        this.setLayout(new BoxLayout(this, 2));
        JPanel leftHalf = new JPanel(){

            public Dimension getMaximumSize() {
                Dimension pref = this.getPreferredSize();
                return new Dimension(Integer.MAX_VALUE, pref.height);
            }
        };
        leftHalf.setLayout(new BoxLayout(leftHalf, 3));
        leftHalf.add(this.createEntryFields());
        leftHalf.add(this.createButtons());
        this.add(leftHalf);
        this.add(this.createAddressDisplay());
    }

    protected JComponent createButtons() {
        JPanel panel = new JPanel(new FlowLayout(4));
        JButton button = new JButton("Set address");
        button.addActionListener(this);
        panel.add(button);
        button = new JButton("Clear address");
        button.addActionListener(this);
        button.setActionCommand("clear");
        panel.add(button);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        if ("clear".equals(e.getActionCommand())) {
            this.addressSet = false;
            this.streetField.setText("");
            this.cityField.setText("");
            this.zipField.setValue(null);
        } else {
            this.addressSet = true;
        }
        this.updateDisplays();
    }

    protected void updateDisplays() {
        this.addressDisplay.setText(this.formatAddress());
        if (this.addressSet) {
            this.addressDisplay.setFont(this.regularFont);
        } else {
            this.addressDisplay.setFont(this.italicFont);
        }
    }

    protected JComponent createAddressDisplay() {
        JPanel panel = new JPanel(new BorderLayout());
        this.addressDisplay = new JLabel();
        this.addressDisplay.setHorizontalAlignment(0);
        this.regularFont = this.addressDisplay.getFont().deriveFont(0, 16.0f);
        this.italicFont = this.regularFont.deriveFont(2);
        this.updateDisplays();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add((Component)new JSeparator(1), "Before");
        panel.add((Component)this.addressDisplay, "Center");
        panel.setPreferredSize(new Dimension(200, 150));
        return panel;
    }

    protected String formatAddress() {
        if (!this.addressSet) {
            return "No address set.";
        }
        String street = this.streetField.getText();
        String city = this.cityField.getText();
        String state = (String)this.stateSpinner.getValue();
        String zip = this.zipField.getText();
        String empty = "";
        if (street == null || empty.equals(street)) {
            street = "<em>(no street specified)</em>";
        }
        if (city == null || empty.equals(city)) {
            city = "<em>(no city specified)</em>";
        }
        if (state == null || empty.equals(state)) {
            state = "<em>(no state specified)</em>";
        } else {
            int abbrevIndex = state.indexOf(40) + 1;
            state = state.substring(abbrevIndex, abbrevIndex + 2);
        }
        if (zip == null || empty.equals(zip)) {
            zip = "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<html><p align=center>");
        sb.append(street);
        sb.append("<br>");
        sb.append(city);
        sb.append(" ");
        sb.append(state);
        sb.append(" ");
        sb.append(zip);
        sb.append("</p></html>");
        return sb.toString();
    }

    protected MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }

    public void focusGained(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof JFormattedTextField) {
            this.selectItLater(c);
        } else if (c instanceof JTextField) {
            ((JTextField)c).selectAll();
        }
    }

    protected void selectItLater(Component c) {
        if (c instanceof JFormattedTextField) {
            final JFormattedTextField ftf = (JFormattedTextField)c;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ftf.selectAll();
                }
            });
        }
    }

    public void focusLost(FocusEvent e) {
    }

    protected JComponent createEntryFields() {
        JPanel panel = new JPanel(new SpringLayout());
        String[] labelStrings = new String[]{"Street address: ", "City: ", "State: ", "Zip code: "};
        JLabel[] labels = new JLabel[labelStrings.length];
        JComponent[] fields = new JComponent[labelStrings.length];
        int fieldNum = 0;
        this.streetField = new JTextField();
        this.streetField.getAccessibleContext().setAccessibleName("Street");
        this.streetField.setColumns(20);
        fields[fieldNum++] = this.streetField;
        this.cityField = new JTextField();
        this.cityField.setColumns(20);
        this.cityField.getAccessibleContext().setAccessibleName("City");
        this.cityField.setEditable(false);
        this.cityField.setEnabled(false);
        fields[fieldNum++] = this.cityField;
        Object[] stateStrings = this.getStateStrings();
        this.stateSpinner = new JSpinner(new SpinnerListModel(stateStrings));
        this.stateSpinner.getAccessibleContext().setAccessibleName("State");
        fields[fieldNum++] = this.stateSpinner;
        this.zipField = new JFormattedTextField(this.createFormatter("#####"));
        fields[fieldNum++] = this.zipField;
        for (int i = 0; i < labelStrings.length; ++i) {
            labels[i] = new JLabel(labelStrings[i], 11);
            labels[i].setLabelFor(fields[i]);
            panel.add(labels[i]);
            panel.add(fields[i]);
            JTextField tf = null;
            tf = fields[i] instanceof JSpinner ? this.getTextField((JSpinner)fields[i]) : (JTextField)fields[i];
            tf.addActionListener(this);
            tf.addFocusListener(this);
        }
        SpringUtilities.makeCompactGrid(panel, labelStrings.length, 2, 10, 10, 10, 5);
        return panel;
    }

    public String[] getStateStrings() {
        String[] stateStrings = new String[]{"Alabama (AL)", "Alaska (AK)", "Arizona (AZ)", "Arkansas (AR)", "California (CA)", "Colorado (CO)", "Connecticut (CT)", "Delaware (DE)", "District of Columbia (DC)", "Florida (FL)", "Georgia (GA)", "Hawaii (HI)", "Idaho (ID)", "Illinois (IL)", "Indiana (IN)", "Iowa (IA)", "Kansas (KS)", "Kentucky (KY)", "Louisiana (LA)", "Maine (ME)", "Maryland (MD)", "Massachusetts (MA)", "Michigan (MI)", "Minnesota (MN)", "Mississippi (MS)", "Missouri (MO)", "Montana (MT)", "Nebraska (NE)", "Nevada (NV)", "New Hampshire (NH)", "New Jersey (NJ)", "New Mexico (NM)", "New York (NY)", "North Carolina (NC)", "North Dakota (ND)", "Ohio (OH)", "Oklahoma (OK)", "Oregon (OR)", "Pennsylvania (PA)", "Rhode Island (RI)", "South Carolina (SC)", "South Dakota (SD)", "Tennessee (TN)", "Texas (TX)", "Utah (UT)", "Vermont (VT)", "Virginia (VA)", "Washington (WA)", "West Virginia (WV)", "Wisconsin (WI)", "Wyoming (WY)"};
        return stateStrings;
    }

    public JFormattedTextField getTextField(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)editor).getTextField();
        }
        System.err.println("Unexpected editor type: " + spinner.getEditor().getClass() + " isn't a descendant of DefaultEditor");
        return null;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("TextInputDemo");
        frame.setDefaultCloseOperation(3);
        frame.add(new TextInputDemo());
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                TextInputDemo.createAndShowGUI();
            }
        });
    }
}

